<?php


// ==================================================
// 🔄 AUTO-ACTUALIZACIÓN DE TABLA (post 08/10/2025)
// ==================================================
add_action('init', 'geohatllm_check_and_update_table');
function geohatllm_check_and_update_table() {
    global $wpdb;
    $table_name = $wpdb->prefix . 'geohatllm_visits';

    // Si ya se actualizó antes, no repetir
    if (get_option('geohatllm_db_updated')) return;

    // Obtener fecha de instalación
    $install_date = get_option('geohatllm_install_date');
    if (!$install_date) return;

    // Fecha límite de corte: 2025-10-08
    $cutoff_date = '2025-10-08 00:00:00';

    // Si el plugin se instaló antes del 08/10/2025 → revisar y actualizar
    if ($install_date < $cutoff_date) {
        // Verificar si la columna 'url' existe
        $column_exists = $wpdb->get_results(
            $wpdb->prepare("SHOW COLUMNS FROM `$table_name` LIKE %s", 'url')
        );

        if (empty($column_exists)) {
            $wpdb->query("ALTER TABLE `$table_name` ADD COLUMN url VARCHAR(255) DEFAULT '' AFTER source");
        }

        // Evitar que vuelva a ejecutarse
        update_option('geohatllm_db_updated', 1);
    }
}


// Finalmente, añade esto al inicio de tu plugin:
add_action('plugins_loaded', function() {
load_plugin_textdomain( 'geohatllm', false, dirname( plugin_basename( __FILE__ ) ) . '/languages' );});

add_action('admin_menu', 'asdrubal_llm_settings_menu');

function asdrubal_llm_settings_menu() {
    add_menu_page(
        __('LLM Settings', 'geohatllm'),
        __('GEOhat LLM', 'geohatllm'),
        'manage_options',
        'geohatllm-settings',
        'asdrubal_llm_settings_page',
        plugins_url('/img/geohat.svg', __FILE__),
        74
    );
}
// =======================
// INTEGRAR EN EL MENÚ WP
// =======================
add_action('admin_menu', function() {
    add_submenu_page(
        'geohatllm-settings',          // Página padre
        __('Tracking LLM', 'geohatllm'),
        __('Tracking LLM', 'geohatllm'),

        'manage_options',
        'geohatllm-tracking',
        'geohat_llm_tracking_admin_page'
    );
    
});
add_action('admin_menu', function() {
    add_submenu_page(
        'geohatllm-settings',        // 🔹 Slug del menú padre
        __('Licencia GEOhat LLM', 'geohatllm'),  // Título de la página
        __('License', 'geohatllm'), // Texto del submenú
        'manage_options',            // Capacidad necesaria
        'geohatllm-license',         // Slug único de la subpágina
        'geohatllm_license_page'     // Función callback
    );
});

// =====================================
// OPCIONES: LLMs habilitados
// =====================================
function geohat_llm_get_sources() {
    return [
        'chatgpt.com' => 'ChatGPT',
        'gemini.google.com' => 'Gemini',
        'claude.ai' => 'Claude',
        'grok.x.ai' => 'Grok'
    ];
}

// Registrar ajustes en la base de datos de WP
add_action('admin_init', function() {
    register_setting('geohatllm_tracking', 'geohatllm_enabled_sources', [
        'type' => 'array',
        'default' => array_keys(geohat_llm_get_sources())
    ]);
});
?>