<div class="geohat-graphics">
<?php
// ==========================
// FILTERED VISITS CHART
// ==========================

global $wpdb;
$table = $wpdb->prefix . 'geohatllm_visits';

// === Retrieve filters from URL ===
$filter_sources = isset($_GET['source']) ? array_map('sanitize_text_field', (array) $_GET['source']) : ['chatgpt', 'gemini', 'claude', 'copilot', 'perplexity'];
$filter_from   = isset($_GET['from_date']) ? sanitize_text_field($_GET['from_date']) : '';
$filter_to     = isset($_GET['to_date']) ? sanitize_text_field($_GET['to_date']) : '';

// === Define dynamic date range ===
$start_date = $filter_from ?: date('Y-m-d', strtotime('-29 days'));
$end_date   = $filter_to ?: date('Y-m-d');

// === Generate array of days between start and end ===
$days = [];
$current = strtotime($start_date);
$end = strtotime($end_date);

while ($current <= $end) {
    $days[] = date('Y-m-d', $current);
    $current = strtotime('+1 day', $current);
}

// === Initialize data arrays ===
$chatgpt_data = [];
$gemini_data  = [];
$claude_data  = [];
$copilot_data = [];
$perplexity_data = [];

foreach ($days as $date) {
    // ChatGPT
    $chatgpt_data[] = (!in_array('chatgpt', $filter_sources)) ? 0 :
        (int)$wpdb->get_var($wpdb->prepare(
            "SELECT SUM(hits) FROM $table WHERE source='chatgpt' AND DATE(visit_date) = %s",
            $date
        ));

    // Gemini
    $gemini_data[] = (!in_array('gemini', $filter_sources)) ? 0 :
        (int)$wpdb->get_var($wpdb->prepare(
            "SELECT SUM(hits) FROM $table WHERE source='gemini' AND DATE(visit_date) = %s",
            $date
        ));

    // Claude
    $claude_data[] = (!in_array('claude', $filter_sources)) ? 0 :
        (int)$wpdb->get_var($wpdb->prepare(
            "SELECT SUM(hits) FROM $table WHERE source='claude' AND DATE(visit_date) = %s",
            $date
        ));

    // Copilot
    $copilot_data[] = (!in_array('copilot', $filter_sources)) ? 0 :
        (int)$wpdb->get_var($wpdb->prepare(
            "SELECT SUM(hits) FROM $table WHERE source='copilot' AND DATE(visit_date) = %s",
            $date
        ));

           // Perplexity
    $perplexity_data[] = (!in_array('perplexity', $filter_sources)) ? 0 :
        (int)$wpdb->get_var($wpdb->prepare(
            "SELECT SUM(hits) FROM $table WHERE source='perplexity' AND DATE(visit_date) = %s",
            $date
        ));
}
?>

<hr>
<h2 class="text-xl mt-6"><?php _e('Visits Chart', 'geohatllm'); ?></h2>
<?php
if (count($filter_sources) === 5) {
    $source_label = __('All LLMs', 'geohatllm');
} else {
    $source_label = implode(', ', array_map('ucfirst', $filter_sources));
}
$sources_list = geohatllm_tracking_sources_list();
if (!empty($filter_sources)) {
        $placeholders = implode(',', array_fill(0, count($filter_sources), '%s'));
        $where_clauses[] = "source IN ($placeholders)";
        $params = array_merge(($params ?? []), $filter_sources);
    }
?>
<div id="last-visited" class="filtros-info">
    <p>(<?= esc_html($start_date); ?> → <?= esc_html($end_date); ?> | <?= esc_html($source_label); ?>)</p>
</div>


<!-- Container with Preline style -->
<div class="relative w-full h-[550px] max-h-[70vh] sm:h-[500px] lg:h-[550px] overflow-hidden">
  <canvas id="geohatllm_chart" class="absolute inset-0 w-full h-full"></canvas>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
  const ctx = document.getElementById('geohatllm_chart');
  if (!ctx) return;

  // === Gradients ===
  const gradientChatGPT = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
  gradientChatGPT.addColorStop(0, 'rgba(16,163,127,0.4)');
  gradientChatGPT.addColorStop(1, 'rgba(16,163,127,0.05)');

  const gradientGemini = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
  gradientGemini.addColorStop(0, 'rgba(66,133,244,0.4)');
  gradientGemini.addColorStop(1, 'rgba(66,133,244,0.05)');

  const gradientClaude = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
  gradientClaude.addColorStop(0, 'rgba(255,179,0,0.4)');
  gradientClaude.addColorStop(1, 'rgba(255,179,0,0.05)');

  const gradientCopilot = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
  gradientCopilot.addColorStop(0, 'rgba(0,120,215,0.4)');
  gradientCopilot.addColorStop(1, 'rgba(0,120,215,0.05)');

const gradientPerplexity = ctx.getContext('2d').createLinearGradient(0, 0, 0, 400);
gradientPerplexity.addColorStop(0, '#191a1ab0');  
gradientPerplexity.addColorStop(1, '#31b7c6a0');  


  new Chart(ctx, {
    type: 'line',
    data: {
      labels: <?= json_encode($days); ?>,
      datasets: [
        {
          label: 'ChatGPT',
          data: <?= json_encode($chatgpt_data); ?>,
          borderColor: '#10A37F',
          backgroundColor: gradientChatGPT,
          borderWidth: 2,
          tension: 0.4,
          pointRadius: 0,
          fill: true,
        },
        {
          label: 'Gemini',
          data: <?= json_encode($gemini_data); ?>,
          borderColor: '#4285F4',
          backgroundColor: gradientGemini,
          borderWidth: 2,
          tension: 0.4,
          pointRadius: 0,
          fill: true,
        },
        {
          label: 'Claude',
          data: <?= json_encode($claude_data); ?>,
          borderColor: '#FFB300',
          backgroundColor: gradientClaude,
          borderWidth: 2,
          tension: 0.4,
          pointRadius: 0,
          fill: true,
        },
        {
          label: 'Copilot',
          data: <?= json_encode($copilot_data); ?>,
          borderColor: '#151a28',
          backgroundColor: gradientCopilot,
          borderWidth: 2,
          tension: 0.4,
          pointRadius: 0,
          fill: true,
        },
                {
          label: 'Perplexity',
          data: <?= json_encode($perplexity_data); ?>,
          borderColor: '#31b8c6',
          backgroundColor: gradientPerplexity,
          borderWidth: 2,
          tension: 0.4,
          pointRadius: 0,
          fill: true,
        }
      ]
    },
    options: {
      responsive: true,
      maintainAspectRatio: false,
      plugins: {
        legend: {
          position: 'top',
          labels: {
            color: '#111827',
            boxWidth: 10,
            usePointStyle: true,
            pointStyle: 'circle'
          }
        },
        tooltip: {
          backgroundColor: '#fff',
          titleColor: '#111827',
          bodyColor: '#4b5563',
          borderColor: '#e5e7eb',
          borderWidth: 1,
          padding: 10,
          displayColors: true,
          usePointStyle: true
        }
      },
      interaction: {
        mode: 'index',
        intersect: false
      },
      scales: {
        x: {
          grid: { display: false },
          ticks: {
            color: '#6b7280',
            font: { size: 12 }
          }
        },
        y: {
          beginAtZero: true,
          grid: {
            color: '#8d096c15',
            borderDash: [4, 4],
            lineWidth: 1.2
          },
          ticks: {
            color: '#6b7280',
            font: { size: 12 }
          }
        }
      }
    }
  });
});
</script>
</div>