<?php
// ==========================
// ÚLTIMAS VISITAS
// ==========================
?>
<hr>
<div>

  <?php
  global $wpdb;
  $table = $wpdb->prefix . 'geohatllm_visits';

  // ==========================
  // Filtros
  // ==========================
    $filter_sources = isset($_GET['source']) ? array_map('sanitize_text_field', (array) $_GET['source']) : ['chatgpt', 'gemini', 'claude', 'copilot', 'perplexity'];
    $filter_from   = isset($_GET['from_date']) ? sanitize_text_field($_GET['from_date']) : '';
    $filter_to     = isset($_GET['to_date']) ? sanitize_text_field($_GET['to_date']) : '';
    $filter_url    = isset($_GET['url']) ? sanitize_text_field($_GET['url']) : '';
    $view_mode = isset($_GET['view_mode']) ? sanitize_text_field($_GET['view_mode']) : 'detailed';

  // ==========================
  // Paginación
  // ==========================
  $current_page = isset($_GET['paged']) ? max(1, intval($_GET['paged'])) : 1;
  $per_page     = 20;
  $offset       = ($current_page - 1) * $per_page;

  // ==========================
  // Construcción dinámica del WHERE
  // ==========================
  $where_clauses = [];
  $params = [];

    if (!empty($filter_sources)) {
        $placeholders = implode(',', array_fill(0, count($filter_sources), '%s'));
        $where_clauses[] = "source IN ($placeholders)";
        $params = array_merge($params, $filter_sources);
    }

    if (!empty($filter_from)) {
        $where_clauses[] = "DATE(visit_date) >= %s";
        $params[] = $filter_from;
    }

    if (!empty($filter_to)) {
        $where_clauses[] = "DATE(visit_date) <= %s";
        $params[] = $filter_to;
    }

          // ✅ Búsqueda insensible a mayúsculas
  if (!empty($filter_url)) {
      $where_clauses[] = "url LIKE %s COLLATE utf8mb4_general_ci";
      $params[] = '%' . $wpdb->esc_like($filter_url) . '%';
  }

  $where_sql = $where_clauses ? ('WHERE ' . implode(' AND ', $where_clauses)) : '';

  // ==========================
  // Consultas SQL según vista y filtro de URL
  // ==========================

switch ($view_mode) {
    case 'grouped_day':
        $group_field = "DATE(visit_date)";
        break;
    case 'grouped_month':
        $group_field = "DATE_FORMAT(visit_date, '%Y-%m')";
        break;
    case 'grouped_year':
        $group_field = "YEAR(visit_date)";
        break;
    case 'grouped_total':
        $group_field = 'total';
        break;
    default:
        $group_field = '';
}

$group_by = [];
if ($group_field) {
    $group_by[] = $group_field;
    $group_by[] = "source";

     // Solo agrupar por URL si el usuario ha filtrado una
    if (!empty($filter_url)) {
        $group_by[] = "url";
    }
}

// 🔹 Agrupación total sin fechas: solo por fuente (y URL si se filtró)
if ($view_mode === 'grouped_total') {
    $group_sql = "source" . (!empty($filter_url) ? ", url" : "");

    $count_sql = "
        SELECT COUNT(*) 
        FROM (
            SELECT 1 
            FROM $table 
            $where_sql 
            GROUP BY $group_sql
        ) AS grouped
    ";

    $data_sql = "
        SELECT 
            source,
            " . (!empty($filter_url) ? "url" : "'' AS url") . ",
            SUM(hits) AS hits
        FROM $table
        $where_sql
        GROUP BY $group_sql
        ORDER BY SUM(hits) DESC
        LIMIT %d OFFSET %d
    ";
} elseif ($group_field) {
    $group_by = [$group_field, "source"];
    if (!empty($filter_url)) {
        $group_by[] = "url";
    }

    $group_sql = implode(', ', $group_by);

    $count_sql = "
        SELECT COUNT(*) 
        FROM (
            SELECT 1 
            FROM $table 
            $where_sql 
            GROUP BY $group_sql
        ) AS grouped
    ";

    $data_sql = "
        SELECT 
            $group_field AS visit_date,
            source,
            " . (!empty($filter_url) ? "url" : "'' AS url") . ",
            SUM(hits) AS hits
        FROM $table
        $where_sql
        GROUP BY $group_sql
        ORDER BY $group_field DESC
        LIMIT %d OFFSET %d
    ";
} else {
    $count_sql = "SELECT COUNT(*) FROM $table $where_sql";
    $data_sql  = "
        SELECT visit_date, source, url, hits 
        FROM $table 
        $where_sql 
        ORDER BY visit_date DESC 
        LIMIT %d OFFSET %d
    ";
}

  $params_for_data = array_merge($params, [$per_page, $offset]);

  $total_items = $params ? $wpdb->get_var($wpdb->prepare($count_sql, ...$params)) : $wpdb->get_var($count_sql);
  $results     = $params_for_data ? $wpdb->get_results($wpdb->prepare($data_sql, ...$params_for_data)) : $wpdb->get_results($data_sql);
  ?>

  <form method="get" class="mb-4 mt-6" action="#last-visited">
      <input type="hidden" name="page" value="<?= esc_attr($_GET['page']) ?>" />
      <label>
          <?php _e('Source:', 'geohatllm'); ?>
          <div id="llm-multiselect" style="position:relative; display:inline-block;">
              <button type="button" id="llm-multiselect-btn" class="button">
              <?php _e('Select LLMs', 'geohatllm'); ?>
              </button>
              <div id="llm-dropdown" style="display:none; position:absolute; z-index:10; background:white; border:1px solid #ccc; padding:8px; border-radius:6px;">
              <?php 
              $filter_sources = ['chatgpt', 'gemini', 'claude', 'copilot', 'perplexity'];
              $selected_sources = isset($_GET['source']) ? (array) $_GET['source'] : $filter_sources;
              foreach ($filter_sources as $src): 
              ?>
                  <label style="display:block; margin-bottom:3px;">
                  <input type="checkbox" name="source[]" value="<?= esc_attr($src) ?>" 
                          <?= in_array($src, $selected_sources) ? 'checked' : '' ?>> 
                  <?= ucfirst($src) ?>
                  </label>
              <?php endforeach; ?>
              </div>
          </div>
      </label>
      <script>
      document.addEventListener('DOMContentLoaded', function() {
          const btn = document.getElementById('llm-multiselect-btn');
          const dropdown = document.getElementById('llm-dropdown');

          btn.addEventListener('click', () => {
              dropdown.style.display = dropdown.style.display === 'none' ? 'block' : 'none';
          });

          document.addEventListener('click', (e) => {
              if (!btn.contains(e.target) && !dropdown.contains(e.target)) {
                  dropdown.style.display = 'none';
              }
          });
      });
      </script>
      <label>
          <?php _e('From:', 'geohatllm'); ?>
          <input type="date" name="from_date" value="<?= esc_attr($filter_from); ?>">
      </label>
      <label>
          <?php _e('To:', 'geohatllm'); ?>
          <input type="date" name="to_date" value="<?= esc_attr($filter_to); ?>">
      </label>
      <label>
          <?php _e('URL contains:', 'geohatllm'); ?>
          <input type="text" name="url" value="<?= esc_attr($filter_url); ?>" type="text">
      </label>
      <label>
          <?php _e('View:', 'geohatllm'); ?>
          <select name="view_mode">
              <option value="detailed" <?= selected($view_mode, 'detailed', false); ?>><?php _e('Detailed (date and time)', 'geohatllm'); ?></option>
              <option value="grouped_day" <?= selected($view_mode, 'grouped_day', false); ?>><?php _e('Grouped by day', 'geohatllm'); ?></option>
              <option value="grouped_month" <?= selected($view_mode, 'grouped_month', false); ?>><?php _e('Grouped by month', 'geohatllm'); ?></option>
              <option value="grouped_year" <?= selected($view_mode, 'grouped_year', false); ?>><?php _e('Grouped by year', 'geohatllm'); ?></option>
              <option value="grouped_total" <?= selected($view_mode, 'grouped_total', false); ?>><?php _e('Global total', 'geohatllm'); ?></option>
          </select>
      </label>

      <input type="submit" class="button" value="<?php esc_attr_e('Filter', 'geohatllm'); ?>">
  </form>

  <h2 class="text-xl mt-6"><?php _e('Latest registered visits', 'geohatllm'); ?></h2>
  <?php
    $csv_url = add_query_arg(array_merge($_GET, ['geohatllm_export_csv' => '1']));
  ?>
  <div class="mb-4 mt-6" id="descargar-datos">
      <a href="<?= esc_url($csv_url); ?>" class="button button-secondary">⬇ <?php _e('Download CSV', 'geohatllm'); ?></a>
  </div>

  <?php
  if (empty($results)) {
      echo '<p>' . esc_html__('No data available yet.', 'geohatllm') . '</p>';
  } else {
      echo '<div class="overflow-x-auto rounded-xl border border-blue-100 shadow-sm mt-6">';
      echo '<table class="min-w-full divide-y divide-gray-200 bg-white">';
      echo '<thead class="bg-blue-50">';
      echo '<tr>';
      echo '<th class="px-4 py-3 text-left text-xs font-semibold text-blue-700 uppercase tracking-wider">' . esc_html__('Date and time', 'geohatllm') . '</th>';
      echo '<th class="px-4 py-3 text-left text-xs font-semibold text-blue-700 uppercase tracking-wider">' . esc_html__('Source', 'geohatllm') . '</th>';
      echo '<th class="px-4 py-3 text-left text-xs font-semibold text-blue-700 uppercase tracking-wider">' . esc_html__('URL', 'geohatllm') . '</th>';
      echo '<th class="px-4 py-3 text-left text-xs font-semibold text-blue-700 uppercase tracking-wider">' . esc_html__('Visits', 'geohatllm') . '</th>';
      echo '</tr>';
      echo '</thead><tbody class="divide-y divide-gray-100">';

      foreach ($results as $row) {
          echo '<tr class="odd:bg-white even:bg-blue-50/40 hover:bg-[#8d096c15] transition-colors">';
          echo '<td class="px-4 py-2 text-sm text-gray-700">' . esc_html($row->visit_date) . '</td>';
          echo '<td class="px-4 py-2 text-sm text-gray-700">' . esc_html(ucfirst($row->source)) . '</td>';
          if (empty($filter_url)) {
              echo '<td class="px-4 py-2 text-sm text-gray-500 italic">' . esc_html__('All URLs', 'geohatllm') . '</td>';
          } else {
              echo '<td class="px-4 py-2 text-sm text-gray-700"><a href="' . esc_url($row->url) . '" target="_blank">' . esc_html($row->url) . '</a></td>';
          }
          echo '<td class="px-4 py-2 text-sm text-gray-700">' . intval($row->hits) . '</td>';
          echo '</tr>';
      }

      echo '</tbody></table></div>';

      // ==========================
      // Paginación
      // ==========================
      $total_pages = ceil($total_items / $per_page);
      if ($total_pages > 1) {
          echo '<div class="mt-4 flex gap-2">';
          for ($i = 1; $i <= $total_pages; $i++) {
              $link = add_query_arg([
                  'paged'     => $i,
                  'page'      => $_GET['page'],
                  'source'    => $filter_sources,
                  'from_date' => $filter_from,
                  'to_date'   => $filter_to,
                  'url'       => $filter_url,
                  'view_mode' => $view_mode
              ]) . '#last-visited';

              $class = $i === $current_page ? 'bg-blue-600 text-white' : 'bg-blue-100 text-blue-700';
              echo "<a class='px-3 py-1 rounded text-sm $class' href='" . esc_url($link) . "'>$i</a>";
          }
          echo '</div>';
      }
  }
  ?>

</div>
<hr>